/*
 * Decompiled with CFR 0.152.
 */
package com.exfantasy.mclib.Utils;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleHelper {
    public static void spawnParticleCube(Level level, SimpleParticleType particle, Vec3 pos, float size, int density) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float halfSize = size / 2.0f;
        for (int x = 0; x < density; ++x) {
            for (int y = 0; y < density; ++y) {
                for (int z = 0; z < density; ++z) {
                    double xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * size / (float)(density - 1));
                    double yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * size / (float)(density - 1));
                    double zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * size / (float)(density - 1));
                    serverLevel.m_8767_((ParticleOptions)particle, xPos += level.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), yPos += level.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), zPos += level.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticleCubeClient(ClientLevel clientLevel, SimpleParticleType particle, Vec3 pos, float size, int density) {
        float halfSize = size / 2.0f;
        for (int x = 0; x < density; ++x) {
            for (int y = 0; y < density; ++y) {
                for (int z = 0; z < density; ++z) {
                    double xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * size / (float)(density - 1));
                    double yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * size / (float)(density - 1));
                    double zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * size / (float)(density - 1));
                    clientLevel.m_7106_((ParticleOptions)particle, xPos += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), yPos += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), zPos += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void spawnHollowParticleCube(Level level, SimpleParticleType particle, Vec3 pos, float size, int density) {
        int z;
        double zPos;
        double yPos;
        double xPos;
        int x;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float halfSize = size / 2.0f;
        float step = size / (float)(density - 1);
        for (x = 0; x < density; ++x) {
            for (int y = 0; y < density; ++y) {
                xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * step);
                yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * step);
                zPos = pos.f_82481_ - (double)halfSize;
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
                zPos = pos.f_82481_ + (double)halfSize;
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
        for (x = 0; x < density; ++x) {
            for (z = 0; z < density; ++z) {
                xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * step);
                yPos = pos.f_82480_ + (double)halfSize;
                zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * step);
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
                yPos = pos.f_82480_ - (double)halfSize;
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
        for (int y = 0; y < density; ++y) {
            for (z = 0; z < density; ++z) {
                xPos = pos.f_82479_ - (double)halfSize;
                yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * step);
                zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * step);
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
                xPos = pos.f_82479_ + (double)halfSize;
                ParticleHelper.addRandomizedParticle(serverLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
    }

    private static void addRandomizedParticle(ServerLevel serverLevel, SimpleParticleType particle, double posX, double posY, double posZ, float size, int density) {
        serverLevel.m_8767_((ParticleOptions)particle, posX += serverLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), posY += serverLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), posZ += serverLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), 0, 0.0, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnHollowParticleCubeClient(ClientLevel clientLevel, SimpleParticleType particle, Vec3 pos, float size, int density) {
        int z;
        double zPos;
        double yPos;
        double xPos;
        int x;
        float halfSize = size / 2.0f;
        float step = size / (float)(density - 1);
        for (x = 0; x < density; ++x) {
            for (int y = 0; y < density; ++y) {
                xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * step);
                yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * step);
                zPos = pos.f_82481_ - (double)halfSize;
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
                zPos = pos.f_82481_ + (double)halfSize;
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
        for (x = 0; x < density; ++x) {
            for (z = 0; z < density; ++z) {
                xPos = pos.f_82479_ - (double)halfSize + (double)((float)x * step);
                yPos = pos.f_82480_ + (double)halfSize;
                zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * step);
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
                yPos = pos.f_82480_ - (double)halfSize;
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
        for (int y = 0; y < density; ++y) {
            for (z = 0; z < density; ++z) {
                xPos = pos.f_82479_ - (double)halfSize;
                yPos = pos.f_82480_ - (double)halfSize + (double)((float)y * step);
                zPos = pos.f_82481_ - (double)halfSize + (double)((float)z * step);
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
                xPos = pos.f_82479_ + (double)halfSize;
                ParticleHelper.addRandomizedParticleClient(clientLevel, particle, xPos, yPos, zPos, size, density);
            }
        }
    }

    private static void addRandomizedParticleClient(ClientLevel clientLevel, SimpleParticleType particle, double posX, double posY, double posZ, float size, int density) {
        clientLevel.m_7106_((ParticleOptions)particle, posX += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), posY += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), posZ += clientLevel.f_46441_.m_188500_() * (double)size / (double)density - (double)(size / (float)(density * 2)), 0.0, 0.0, 0.0);
    }
}

